package ONVIF::Analytics::Types::PTZStatus;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Position_of :ATTR(:get<Position>);
my %MoveStatus_of :ATTR(:get<MoveStatus>);
my %Error_of :ATTR(:get<Error>);
my %UtcTime_of :ATTR(:get<UtcTime>);

__PACKAGE__->_factory(
    [ qw(        Position
        MoveStatus
        Error
        UtcTime

    ) ],
    {
        'Position' => \%Position_of,
        'MoveStatus' => \%MoveStatus_of,
        'Error' => \%Error_of,
        'UtcTime' => \%UtcTime_of,
    },
    {
        'Position' => 'ONVIF::Analytics::Types::PTZVector',
        'MoveStatus' => 'ONVIF::Analytics::Types::PTZMoveStatus',
        'Error' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'UtcTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
    },
    {

        'Position' => 'Position',
        'MoveStatus' => 'MoveStatus',
        'Error' => 'Error',
        'UtcTime' => 'UtcTime',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::PTZStatus

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZStatus from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Position


=item * MoveStatus


=item * Error


=item * UtcTime




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::PTZStatus
   Position =>  { # ONVIF::Analytics::Types::PTZVector
     PanTilt => ,
     Zoom => ,
   },
   MoveStatus =>  { # ONVIF::Analytics::Types::PTZMoveStatus
     PanTilt => $some_value, # MoveStatus
     Zoom => $some_value, # MoveStatus
   },
   Error =>  $some_value, # string
   UtcTime =>  $some_value, # dateTime
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

